/******************************************************************************/
#include "stdafx.h"
/******************************************************************************

   EarlyZ is a technique of rejecting pixels which aren't visible
   Another way of doing this optimization is to sort objects manually before rendering, so they will be rendered in front-to-back order.
   -   Advantage of EarlyZ is that it's simpler to use and it's pixel-precise, instead of object-precise as in manual object sorting
   -Disadvantage is that it requires additional pass of rendering, but fortunately it consists only of vertex transformations and z-buffer setting

/******************************************************************************/
Mesh mbox ,
     mball;
/******************************************************************************/
void InitPre()
{
   App.name="Early Z";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   PakAdd("../data/engine.pak");

   D.full(true).bumpMode(BUMP_RELIEF); // setup relief bump mapping to enable pixel-heavy processing
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=3;

   Material *material=Materials("../data/mtrl/brick/0.mtrl");

   mbox .create(1).B(0).create( Box(5),VTX_TX0|VTX_NRM|VTX_TNG).reverse();
   mball.create(1).B(0).create(Ball(1),VTX_TX0|VTX_NRM|VTX_TNG);

   mbox .setMaterial(material).setRender().setBox();
   mball.setMaterial(material).setRender().setBox();

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,10,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT));
   return true;
}
/******************************************************************************/
void Render()
{
   // to use EarlyZ just render in 'RM_EARLY_Z' mode all big objects which occlude others
   switch(Renderer())
   {
      case RM_EARLY_Z:       // in this tutorial we'll simply render the same things as in 'RM_SOLID' mode
         if(!Kb.b(KB_SPACE)) // disable EarlyZ when space pressed
         {
                   mbox .draw(MatrixIdentity);
            FREP(5)mball.draw(Matrix(2,Vec(0,0,5-i))); // draw in back-to-front order to present EarlyZ speedup
         }
      break;

      case RM_SOLID:
                mbox .draw(MatrixIdentity);
         FREP(5)mball.draw(Matrix(2,Vec(0,0,5-i))); // draw in back-to-front order to present EarlyZ speedup
      break;

      case RM_LIGHT:
         LightPoint(25,Vec(0,3,-1)).add();
      break;
   }
}
void Draw()
{
   Renderer(Render);
   D.text(0,0.9,S+"Fps: "+Tm.fps);
   D.text(0,0.8,  "Hold Space to disable EarlyZ");
}
/******************************************************************************/
